#!/usr/bin/env Rscript

### Diff. gene expression with sleuth

################################################
#### Load required library
################################################
library(sleuth)

################################################
#### Read arguments from CLI
################################################

args <- commandArgs(trailingOnly = T)

in_sleuth <- args[1]
out_folder <- args[2]

################################################
#### If it does not exist, create out dir
################################################

dir.create(out_folder, recursive = T, showWarnings = F)

################################################
#### Load sleuth object
################################################

load(file = in_sleuth)

################################################
#### Run sleuth fit
################################################

so <- sleuth_fit(so)
so <- sleuth_fit(so, ~condition, "full")
so <- sleuth_fit(so, ~1, "reduced")
so <- sleuth_lrt(so, "reduced", "full")

sleuth_table <- sleuth_results(so, "reduced:full", "lrt", show_all = FALSE)

################################################
#### write to file
################################################

write.csv(sleuth_table, paste(out_folder, "sleuth_dge.csv", sep = "/"), row.names = F)
