## Metabolic modeling for the identification of amplification targets
All simulations are based on a genome-scale stoichiometric network model of *Synechocystis* published by Knoop and colleagues (Knoop and Steuer, 2015). A modified, extended version was used, kindly provided by Ralf Steuer. All flux distributions have been calculated with constraint-based flux analysis using COBRApy (v.0.25.0) (Ebrahim et al., 2013). To simulate phototrophic growth, different constraints were applied to the model of Synechocystis (see Table S5 (SI)).

FSEOF (Choi et al., 2010) was used to find amplification targets by simulating the transition from a wildtype to a production phenotype. All isoreactions were excluded for the transition experiments (Knoop and Steuer, 2015). The initial fluxes of all reactions were calculated by using the objective function to maximize the growth rate. Then, the theoretical maximum squalene production rate was calculated by setting the objective function as maximizing squalene flux. Subsequently, under constant light flux, the product formation flux rate was stepwise increased from 0% to 67% of the maximum achievable rate, while the growth rate was maximized. Only targets for which the overall mean flux rate from maximum biomass synthesis to maximum product synthesis increases were chosen. Additionally, only reactions that did not change flux direction during transition were considered. To confirm the results, flux variability analysis was performed for the selected targets, by stepwise increasing squalene flux from 0% to 67% of the maximum rate and subsequently maximizing biomass synthesis. For each simulation step, the variability of all selected targets was determined. To visualize the flux distributions a simplified network was implemented with d3flux (v.0.2.7) (St. John, 2016), a d3.js based visualization tool for COBRApy models.