## Fluorescein diffusion assay

To assess diffusion of chemical compounds within RoPod chambers containing plants, Arabidopsis Col-0 seeds were surface sterilized in opened 2 ml tubes for 2 h in an air-tight box containing chlorine gas, produced by the mix of 50 ml of sodium hypochlorite 10% (Roth, ref. 9062.3) and 2 ml of 37% hydrochloric acid (Merck, ref. 1.00317.1000). Seeds were then aerated for 10 min in a sterile bench to remove the left-over chlorine gas. Seeds were then transferred, with a sterile toothpick, in 2-wells Ibidi chambered coverslips (cat # 80,286 #1.5 polymer coverslip, hydrophobic, sterilized, Ibidi, Germany) filled with 1 mL of growth medium in each well (0.5 × MS (Serva, ref. 47,515); MES 5 mM (Sigma, ref. M8250); 1% sucrose; pH 5.7 adjusted with KOH; 0.8% Plant agar (Duchefa, ref. M1002). As the height of the Ibidi chamber is too small to accommodate nine days old seedlings, the seeds were put on the surface of the agar to be first cultivated for eight days horizontally at 21 °C, 16 h illumination, 100 µmol m−2.s−1, until the root penetrate the agar and reached the glass bottom. Then, the RoPods were incubated at 45° angle for one day before image acquisition. At the start of the recording, each well containing plants was filled with 1 ml of fluorescein at 4 μg.ml-1 diluted in a liquid 0.5 × MS (final concentration after diffusion: 2 µg.ml−1). Imaging was performed using Leica DMI8 confocal microscope and HC PL APO CS2 20 × objective (excitation, 488 nm, emission, 498–550 nm, pinhole size of 1 Airy Unit) (Leica Microsystems, Germany), pixel dimensions 0.48 µm px−1, image size 512 × 512 px, 8-bit. The root hairs that were growing at the beginning of the recording were selected for analysis. To obtain a complete view of the root hairs, a z-stack was performed to cover 92 µm height with each section separated with 10 µm. The images were then processed on *Fiji* to obtain maximum intensity projection. A circular region of interest (ROI) with a 12 µm diameter was used to measure the mean grey value on the selected root hair tips, on the base of the corresponding root hair tip and in the upper left corner of the image for the mean grey value of background. The experiment was performed in two individual boxes containing 2 to 3 roots each, 2 to 8 root hairs analyzed per root.

For the fluorescein diffusion assay in the solid medium and without plants, 2-wells Ibidi chambers filled with 1 ml of the same 0.5 × MS agar in each well. 1 ml of liquid growth medium supplemented with 140 µg.ml−1 of fluorescein solution was added at the start of the recording (final concentration after diffusion: 70 µg.ml−1). The same microscope settings as for the previous diffusion assay were used (pixel dimensions 1.14 µm.px−1, image size 512 × 512 px, 8-bit). The fluorescence was recorded in 4 RoPods, with 2 to 3 fields of view chosen at random positions in each box. *Fiji* software was used for image analysis. An orthogonal projection was carried out in the middle of each acquisition area with the Orthogonal view tool. To define the bottom of the RoPod, the orthogonal view of the image acquired 2 h after the start of treatment was used. A rectangular ROI with the width of the orthogonal projection image and 10 µm in height was drawn at the bottom of the RoPod chamber. This ROI was reused to measure the mean grey value on the orthogonal view for each time point recorded at the same location.