## Flux balance analysis (FBA) to define pathways

As we suspect that the root may convert sucrose into other sugars before secretion, we would like to find out the genes involved in these conversion pathways for further analysis. To assign genes in the metabolic network to these pathways, we applied FBA (Orth, J.D. et al., 2010), which searches for the combination of genes and reactions that results in the highest yield for such conversions, assuming sucrose to be the sole input carbon source of the metabolic network.

We used the AraGEM (de Oliveira Dal’Molin, C.G. et al., 2009) a curated FBA model of *Arabidopsis*, to perform our simulations and define the genes associated with each conversion pathway. The AraGEM model is published with 3 different sets of parameters that correspond to their own case of metabolism: (a) photosynthesis, (b) photorespiration, and (c) non-photosynthetic cell. Case (c) is relevant to the root condition, as it considers the conversion of sucrose into other biomass metabolites. Hence, our simulations are developed from case (c), which uses sucrose as the input carbon source.

We switched off the default objective function of AraGEM, which includes a set of metabolites with weights found in real plants. To investigate the conversion of sucrose into different sugars, we set different monosaccharides, disaccharides and combinations of monosaccharides as the objective; these include all possible monosaccharides and disaccharides in AraGEM. In total, we analyzed 11 different objective functions: (1) maltose, (2) glucose, (3) beta-D-fructose, (4) D-galactose, (5) D-xylose, (6) glucose + beta-D-fructose, (7) glucose + D-galactose, (8) glucose + D-xylose, (9) beta-D-fructose + D-galactose, (10) beta-D-fructose + D-xylose, (11) D-galactose + D-xylose. Note that the molecules within objective functions have equal weights, as some of them have multiple sugar molecules.

We used the python package COBRApy (Ebrahim, A. et al., 2013) along with the GUROBI solver (Gurobi Optimizer Version 3.0. Houston, Texas: Gurobi Optimization, Inc., April 2010. (software program)) to perform FBA simulation. For each of the 11 objective functions, we performed parsimony-FBA simulation (Holzhütter, H.-G., 2004) to find out the most efficient reactions that perform the conversion of sucrose into the objective sugars. We also calculated the shadow price (Reznik, E., 2013) of each metabolite involved in these reactions; a metabolite with negative shadow price is deemed critical, as an extra supply of this metabolite leads to a higher flux of the objective function. Reactions that have critical metabolites both at their input and output are also considered critical. We collected all the critical reactions of an objective function, and the genes associated with any critical reactions are assigned to the pathway (refer to Table S6 for the genes in these pathways).