# Experimental Setup

**Field Trial Setting:** 
- The trial took place at the INIA-Huasco experimental center located in the southern Atacama Desert (Vallenar, Chile, 28°34′ S, 70°47′ W and 469 m.a.s.l.) during the 2019/2020 growing season (sowing on 26 September 2019, harvest on 21 February 2020).
- The Atacama desert is one of the driest regions in the world, ensuring that rainfall would not influence the irritation treatment of the experiment.

**Soil Characteristics:** 
- Sandy loam textural class, composed of sand (75.5%), silt (10.9%) and clay (13.7%), with a low organic matter content (2.0%), an alkaline pH (8.1), slight salinity (2.4 dS m−1), and with a basic content of N-P-K (45-21-311 mg kg−1 respectively)

**Experimental Design:**
- Nine coastal lowland self-pollinated quinoa lines (CLS-1 to CLS-9) and one commercial cultivar (cv Regalona)
- Plots here 2 x 4 m and contained four rows of quinoa with an inter-row spacing of 0.5 m
- Three plots of each line were sown for each treatment.
- Seeds were sown at a density of 15 kg ha−1 with >85% germination.
- Two treatments: 
    - <ins>Full Irrigation (FI):</ins> Considered the reposition of ET<sub>0</sub> and the lack of a crop coefficient (K<sub>c</sub>) for quinoa growing in the region.
    - <ins>Reduced Irrigation (RI):</ins> Defined a severe reduction of irrigation time (50%) and kept the same schedule as for the full irrigation treatment (every second or third day) by means of pressurized drip lines. RI treatment started at growth stage 20 (branching, extended BBCH).
- Fertilizer was provided at sowing (75-120-60 N-P-K) and an additional 75 N was provided at growth stage 12 (second pair of leaves visible, extended BBCH).
- Chlorothalonil (2 L ha−1 BRAVO 720, Syngenta) was applied from growth stage 16 (six pairs of leaves visible, extended BBCH) to manage disease.
- Weather data was collected via meteorlogical station located at the INIA-Huasco experimental setup, approximately 200 meters from the trial.
- Soil sensors (located at the yellow stars in the figure below) recorded volumetric water content and temperature.

## Figure: Field trial plot layout

![Quinoaplots](quinoa_trialplots.png)
