load(file = "runs/kallisto_combined/mothertableV3.Rdata")

library("reshape2") # this library gives us the "melt" function
# basically, makes preparing data for ggplot2 easier
# import
mapman <- read.delim("studies/AthalianaReferences/resources/mapmanTAIR10.txt")
head(mapman)
# we can remove the quotations now
mapman <- data.frame(apply(mapman, c(1, 2), function(x) gsub("'", "", x)))
# Hmmm, this time the IDs don't match, clean up time!
# in the "dfr" table we can use the locus ID in uppercase
head(dfr$locus)
# in the MapMan data we have gene IDs in lowercase
head(mapman$IDENTIFIER)
# changing to upper case is easy
mapman$IDENTIFIER <- toupper(mapman$IDENTIFIER)
# then we merge the tables
dfr_mapman <- merge(
  x = dfr, y = mapman, by.x = "locus",
  by.y = "IDENTIFIER", all.x = TRUE
)

##  Now we can look at the fold change of differentially
##  expressed transcription factors
dfr_mapman_sig <- dfr_mapman[dfr_mapman$treatment.vs.mock_significant, ]
i_TFs <- grep("^RNA.regulation of transcription", dfr_mapman_sig$NAME)
head(dfr_mapman_sig[i_TFs, c("log2FC", "NAME")])

## or we can visualize redox response ##
i_redox <- grep("^redox", dfr_mapman_sig$NAME)
# get significant redox gene tpm
to_plot <- dfr_mapman_sig[i_redox, grep("tpm", colnames(dfr_mapman_sig))]
colnames(to_plot) <- gsub("_tpm", "", colnames(to_plot)) # fix names
to_plot <- to_plot[apply(to_plot, 1, max) > 100, ] # filter to reduce noise
# transform to Z-score (mean center, divide by standard deviation)
to_plot <- t(scale(t(to_plot)))
head(to_plot)
# melt, helps us prepare data for ggplot2
to_plot <- melt(to_plot)
head(to_plot)
# now more remain, just for our own organization this time
colnames(to_plot) <- c("gene_index", "replicate", "z.score")
redox_plot <- ggplot(data = to_plot, aes(x = replicate, y = z.score, group = gene_index)) +
  geom_line()

redox_plot
dev.copy2eps(file = "runs/results_figures/redox.eps", width = 6, height = 4)
# notice anything interesting about the replicates?

# <<< challenge assignment >>> #
# 1. we could have imported the mapman table and removed quotes in
#    one step. Do so (hint ?read.delim).
# 2. Take a careful look at the results and original file, and
#    and try and troubleshoot what went wrong.

save(mapman, dfr_mapman, dfr_mapman_sig, file = "runs/mapman/mapman.RData")

# clean up time
remove(mapman, dfr_mapman, dfr_mapman_sig, i_redox, i_TFs, to_plot, redox_plot)
