load(file = "runs/kallisto_combined/mothertableV3.Rdata")

# now we make a data.frame with the data required for Mapman loading
# if you have more fold-changes, you can load more than one
forMapman <- dfr[, c("locus", "log2FC")]
head(forMapman)
# now we export the data.frame in biologist and mapman readable format
dir.create(path = "runs/mapman", recursive = T, showWarnings = F)
write.table(forMapman,
  file = "runs/mapman/forMapmanloading.txt",
  quote = F, sep = "\t", row.names = F
)
remove(forMapman)
