load(file = "runs/kallisto_combined/mothertableV3.Rdata")

# import the tair annotations
tair_anno <- read.delim(
  "studies/AthalianaReferences/resources/TAIR10_functional_descriptions.txt"
)
# merge with main table
dfr_anno <- merge(
  x = dfr, y = tair_anno, by.x = "target_id",
  by.y = "Model_name", all.x = TRUE
)
# we can now search these descriptions
i_pathogen <- grep("pathogen", dfr_anno$Computational_description, ignore.case = T)
i_pathogen # list of indexes with "pathogen" in description
# look at first hit
dfr_anno[i_pathogen[1], ]

# clean up time
remove(dfr_anno, tair_anno, i_pathogen)
