load("runs/mapman/mapman.RData")

# get indices of biotic stress signalling  genes
i_biotic <- grep("stress.biotic.signalling", dfr_mapman$NAME)
# get tpm subtable for plotting
to_plot <- dfr_mapman[i_biotic, grep("tpm", colnames(dfr_mapman))]
to_plot <- log2(to_plot + 1)
colnames(to_plot) <- gsub("_tpm", "", colnames(to_plot))
# the melt function likes names (here AGIs)
to_plot$Name <- dfr_mapman[i_biotic, "locus"]
# make a reasonable order
# (here sorted by mean, but clustering would work too)
to_plot <- to_plot[order(rowMeans(to_plot[, 1:6])), ]
# this will force the plot to keep the current ordering
to_plot$Name <- factor(to_plot$Name, levels = unique(to_plot$Name))
# setup data.frame ggplot2 style
x <- melt(to_plot)
colnames(x) <- c("AGI", "Replicate", "log2")
# make plot
px <- ggplot(x, aes(Replicate, AGI)) +
  geom_tile(aes(fill = log2)) +
  scale_fill_gradient(low = "black", high = "red")
# display plot
px
dev.copy2eps(file = "runs/results_figures/biotic_signaling.eps")
