# Singularity from Docker

While there's probably better ways, a 1:1 generation of the
Singularity image from Docker would not have entirely made sense.
So instead a singularity build file was autogenerated from the Dockerfile,
changes were applied, and a singularity image was subsequently built.

## autogen
The file Singularity.def was initially created automatically from the 'maindocker/Dockerfile' via
spython, according to info found here: https://stackoverflow.com/questions/60314664/how-to-build-singularity-container-from-dockerfile
in the answer from Serge. 

Briefly, in a virtual environment:

```bash
pip install spython
cd </path/to/maindocker>
spython recipe Dockerfile &> ../singularity/Singularity.def
```
## tailor for singularity (and to actually build successfully)
Substantial modifications were necessary, e.g.
making variables TZ, DOCKER\_USER, and DEBIAN\_FRONTEND available during
and after build as necessary (changing to be in the right `%` block, and
adding `export`).

Changing '/home' to '/opt', as singularity will mount the 'home' from the
host and having container content there can lead to trouble. 

Changing the entry command to simply be `/bin/bash`

Remove recipe `cd` changes so that default working directory is $HOME

Instead of an exact listing, please simply find the file Singularity.def,
included here with modifications. Run a diff to the automatically
generated one, if useful. 

## build
`sudo singularity build rnaseq-workshop.sif Singularity.def`
