head(df0)
# now we will learn about how ggplot makes figures
# the minimal information is where is the data, what is the x variable
# and what is the y variable and what we want to plot
# let's try

# this will make and save plot object
baseplot <- ggplot(data = df0, aes(x = hp, y = gas_mileage)) +
  geom_point()
# the first line indicates the data, what x is and what y is
# the second line says we want points

# this will display plot object
baseplot

# now we can customize that plot and make it prettier
# first off, different style, we do that by using theme
baseplot + theme_minimal() # display plot object + modification
# or alternatively, if you prefer
baseplot + theme_bw()
# now we'll save theme_bw with the object for later use
baseplot <- baseplot + theme_bw()

# now we want colored dots, simply red ones
# google ``r colors" for an idea of the named colors available in R
# you can choose them by name, number or hexcode; we like names
baseplot + geom_point(color = "firebrick")

# and a different size and shape
baseplot + geom_point(color = "firebrick", shape = 18, size = 4)

# or choose colors based on something else, like the number of cylinders

# note, that while many things can just be 'added' to a ggplot,
# a second ggplot object is not one of them, so we'll start over
# as it's normally best to specify dynamic color as an
# argument to aesthetics (called aes).
ggplot(data = df0, aes(x = hp, y = gas_mileage, color = cyl)) +
  geom_point(shape = 18, size = 4) +
  theme_bw()

# you can also make your color changes abrupt, not continuous,
# by defining cyl as a factor rather than a number
# first check what they are
class(df0$cyl)
# now make them a factor
baseplot <- ggplot(
  data = df0,
  aes(x = hp, y = gas_mileage, color = as.factor(cyl))
) +
  geom_point(shape = 18, size = 4) +
  theme_bw()
baseplot
# not the best colors, but you can modify them using scale_color_manual
# to do that you need to know which levels you have as your factors
levels(as.factor(df0$cyl))
# and now you can look at colors and decide what is what
baseplot <- baseplot +
  scale_color_manual(
    values = c(
      "4" = "black",
      "6" = "orange",
      "8" = "red3"
    ),
    name = "cylinders"
  )
baseplot
# finally, a little more polishing
baseplot +
  xlab("gross horsepower") +
  ylab("miles per gallon") +
  theme(text = element_text(size = 16))
