load(file = "runs/kallisto_combined/mothertableV3.Rdata")

# now we make a data.frame with the data required for Mapman loading
# if you have more fold-changes, you can load more than one
forMapman <- dfr[!duplicated(dfr$locus), c("locus", "log2FC")]

### TODO: the `duplicated` solution is a quick-and-dirty fix to avoid duplicated 
### locus IDs coming from mapping on transcript level 
### (plus Mapman accepts AT1G01040, not AT1G01040.1)

head(forMapman)
# now we export the data.frame in biologist and mapman readable format
dir.create(path = "runs/mapman", recursive = T, showWarnings = F)
write.table(forMapman,
  file = "runs/_backup/mapman/forMapmanloading.txt",
  quote = F, sep = "\t", row.names = F
)
remove(forMapman)
