load(file = "runs/kallisto_combined/mothertableV3.Rdata")

# moving back to R, import the data
serk <- read.csv("studies/Fan2016_SERK_review/resources/serk_interacting.agi", header = F)
# make another copy of the main table
dfr_serk <- dfr
# setup a TRUE/FALSE column for SERK interaction
dfr_serk$serk_interacting <- FALSE
dfr_serk$serk_interacting[dfr_serk$locus %in% serk[, 1]] <- TRUE
# this makes for easy subsetting (if not strictly necessary for this example)
# visualize, for example, the logFC of SERK interacting genes.
to_plot <- dfr_serk[dfr_serk$serk_interacting, "log2FC", drop = F]
px <- ggplot(to_plot, aes(log2FC)) +
  geom_histogram(binwidth = 0.5) +
  xlim(-max(abs(to_plot)), max(abs(to_plot)))
px
# hmm, it looks like these genes are upregulated
# more often than not, let's test it
wilcox.test(dfr_serk$log2FC ~ dfr_serk$serk_interacting)
# looks like there's a difference, whether something like this
# is interesting or not will depend heavily
# on the biological knowledge you're bringing in to the question.

# clean up time
remove(serk, dfr_serk, to_plot, px)
