#!/bin/bash
# for each word following "in" the loop will be ran with
# this word saved in the variable $sample

for sample in treatment2 treatment3 mock1 mock2 mock3
do  # open the loop

  echo "running sample: $sample"
  java -jar $HOME/sw/Trimmomatic-0.39/trimmomatic-0.39.jar SE \
    assays/Bernsdorff2016_Illumina/dataset/Col0${sample}.fastq.gz \
    runs/trimmed_fastq/Col0${sample}.trimmed.fastq \
    ILLUMINACLIP:$HOME/sw/Trimmomatic-0.39/adapters/TruSeq3-SE.fa:2:30:10 \
    MAXINFO:50:0.8 MINLEN:36

  kallisto quant -i runs/kallisto_index/Ath_kallisto_index  \
    -o runs/kallisto_results/${sample} --single \
    -b 30 -l 190 -s 20 runs/trimmed_fastq/Col0${sample}.trimmed.fastq

done  # close the loop
