# docker setup

> Easiest: go to supermicro, get rnaseq\_docker.tar. Skip to the 'import' instructions,
> and then to the 'start docker container' part.

Notes on how image was made and how to use.

This is a quick hack together of things and my Docker foo could be... better. 
It is in no-way a good practice example.

## build docker image

`sudo docker build -t rnaseq --rm .`

## start docker container

Do this from the parent directory of the 'rnaseq-workshop' repository, so that the mounted folder contains the repository

`sudo docker run -it --name rnalive --rm --mount type=bind,source="$(pwd)"/rnaseq-workshop,target=/home/ZIM-gast/rnaseq-workshop rnaseq:latest`

> Note difference to user instructions with `--rm`, so you don't end up with
> tons of copies of the same container, nor naming conflicts.

This should open a prompt in the container. Start with `cd rnaseq-workshop`, and hopefully after that 
things should run about the same as before. Except that Rstudio is not installed in this docker, but
rather a second one.

 

## clean up (e.g. if you've been making a lot of failed builds and want some HD space back)

```
sudo docker container prune
sudo docker image prune
```

## export 
first run the following to get the image ID from the tag / name

`sudo docker image save rnaseq:latest > rnaseq_docker.tar`

## import
`sudo docker image load -i rnaseq_docker.tar`

